package com.example.bytesbee.alphabets.activities.utils;

import static android.view.View.VISIBLE;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatButton;
import androidx.cardview.widget.CardView;
import androidx.core.content.res.ResourcesCompat;

import com.example.bytesbee.alphabets.activities.BuildConfig;
import com.example.bytesbee.alphabets.activities.constants.Config;
import com.example.bytesbee.alphabets.activities.constants.IAlphaListener;
import com.example.bytesbee.alphabets.activities.constants.IConstants;
import com.example.bytesbee.alphabets.activities.constants.IDialogListener;
import com.example.bytesbee.alphabets.activities.constants.StaticNames;
import com.example.bytesbee.alphabets.activities.easyads.EasyAdsDynamic;
import com.example.bytesbee.alphabets.activities.R;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * @author Prashant
 * @company BytesBee
 * @link http://bytesbee.com/
 */
public class Utils implements IConstants {

    public static boolean isEmpty(final Object s) {
        if (s == null) {
            return true;
        }
        if ((s instanceof String) && (((String) s).trim().length() == 0)) {
            return true;
        }
        if (s instanceof Map) {
            return ((Map<?, ?>) s).isEmpty();
        }
        if (s instanceof List) {
            return ((List<?>) s).isEmpty();
        }
        if (s instanceof Object[]) {
            return (((Object[]) s).length == 0);
        }
        return false;
    }

    public static void getErrors(final Exception e) {
        final String stackTrace = "Prashant ::" + Log.getStackTraceString(e);
        Utils.sout("" + stackTrace);
    }

    public static String getVersionName() {
        return "v " + BuildConfig.VERSION_NAME;
    }

    public static void sout(String msg) {
        if (IS_TRIAL) {
            System.out.println("Prashant :: " + msg);
        }
    }

    public static void shareApp(final Activity mActivity, final String title) {
        final String app_name = android.text.Html.fromHtml(title).toString();
        final String share_text = android.text.Html.fromHtml(mActivity.getResources().getString(R.string.strShareContent)).toString();
        final Intent sendIntent = new Intent();
        sendIntent.setAction(Intent.ACTION_SEND);
        sendIntent.putExtra(Intent.EXTRA_TEXT, app_name + "\n\n" + share_text + "\n\n" + DEFAULT_UPDATE_URL + mActivity.getPackageName());
        sendIntent.setType("text/plain");
        mActivity.startActivity(sendIntent);
    }

    public static void shareApp(final Activity mActivity) {
        shareApp(mActivity, mActivity.getResources().getString(R.string.app_name));
    }

    public static void rateApp(final Activity mActivity) {
        final String appName = mActivity.getPackageName();
        try {
            mActivity.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(MARKET_URL + appName)));
        } catch (android.content.ActivityNotFoundException anfe) {
            mActivity.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(DEFAULT_UPDATE_URL + appName)));
        }
    }

    public static void showOKDialog(final Activity mActivity, int title, int message, final IDialogListener iDialogListener) {
        showOKDialog(mActivity, mActivity.getString(title), mActivity.getString(message), iDialogListener);
    }

    public static void showOKDialog(final Activity mActivity, String title, String message, final IDialogListener iDialogListener) {
        final AlertDialog.Builder builder = new AlertDialog.Builder(mActivity);

        CardView view = (CardView) mActivity.getLayoutInflater().inflate(R.layout.dialog_custom, null);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            SessionManager sessionManager = new SessionManager(mActivity);
            if (sessionManager.isRTLOn()) {
                view.setLayoutDirection(View.LAYOUT_DIRECTION_RTL);
            } else {
                view.setLayoutDirection(View.LAYOUT_DIRECTION_LTR);
            }
        }

        final TextView txtTitle = view.findViewById(R.id.txtTitle);
        final TextView txtMessage = view.findViewById(R.id.txtMessage);
        final AppCompatButton btnCancel = view.findViewById(R.id.btnCancel);
        final AppCompatButton btnDone = view.findViewById(R.id.btnDone);

        if (Utils.isEmpty(title)) {
            txtTitle.setVisibility(View.GONE);
        } else {
            txtTitle.setVisibility(View.VISIBLE);
            txtTitle.setText(title);
        }
        txtMessage.setText(message);

        builder.setView(view);

        final AlertDialog alert = builder.create();

        btnCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                alert.dismiss();
            }
        });
        btnCancel.setVisibility(View.GONE);
        btnDone.setText(R.string.strOK);
        btnDone.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                iDialogListener.yesButton();
                alert.dismiss();
            }
        });

        alert.getWindow().setBackgroundDrawableResource(android.R.color.transparent);
        alert.setCanceledOnTouchOutside(false);
        alert.setCancelable(false);
        alert.show();

    }

    public static void setVibrate(final Context mContext) {
        try {
            Vibrator vib = (Vibrator) mContext.getSystemService(Context.VIBRATOR_SERVICE);
            // Vibrate for 500 milliseconds
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                vib.vibrate(VibrationEffect.createOneShot(DEFAULT_VIBRATE, VibrationEffect.DEFAULT_AMPLITUDE));
            } else {
                //deprecated in API 26
                vib.vibrate(DEFAULT_VIBRATE);
            }
        } catch (Exception e) {
        }
    }

    public static void RTLSupport(Window window) {
        try {
            window.getDecorView().setLayoutDirection(View.LAYOUT_DIRECTION_RTL);
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    public static void loadBannerAd(final Activity mActivity) {
        try {
            final LinearLayout layout = mActivity.findViewById(R.id.adsBottomView);
            layout.setVisibility(VISIBLE);

            if (Config.ADS_SHOWN) {
                EasyAdsDynamic.MainAppId(mActivity);
                final AdView mAdView = new AdView(mActivity);
                layout.removeAllViews();
                EasyAdsDynamic.forBanner(mActivity)
                        .withLayout(layout, mAdView)
                        .listener(new AdListener() {
                            @Override
                            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                                super.onAdFailedToLoad(loadAdError);
                                //Utils.sout("onAdFailedToLoad:: " + loadAdError.getMessage());
                            }

                            @Override
                            public void onAdLoaded() {
                                super.onAdLoaded();
                                //Utils.sout("onAdLoaded");
                            }
                        })
                        .adUnitId(Config.BANNER_ADS_ID)
                        .show();
            } else {
                layout.setVisibility(View.GONE);
            }

        } catch (Exception ignored) {
        }
    }

    private static InterstitialAd mInterstitialAd;

    public static void firstLoadAds(Activity mActivity) {
        if (Config.ADS_SHOWN) {
            InterstitialAd.load(mActivity, Config.INTERSTITIAL_ADS_ID, new AdRequest.Builder().build(), new InterstitialAdLoadCallback() {
                @Override
                public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                    super.onAdLoaded(interstitialAd);
                    mInterstitialAd = interstitialAd;
                }

                @Override
                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    // Handle the error
                    mInterstitialAd = null;
                }
            });
        }
    }

    public static void showIntAds(final Activity mActivity, final Class cls) {
        showIntAds(mActivity, cls, ZERO, null);
    }

    public static void showIntAds(final Activity mActivity, final Class cls, final int what, final Handler handler) {
        if (Config.ADS_SHOWN) {
            if (mInterstitialAd != null) {
                mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback() {
                    @Override
                    public void onAdDismissedFullScreenContent() {
                        super.onAdDismissedFullScreenContent();
                        openNextActivity(mActivity, cls, what, handler);
                        firstLoadAds(mActivity);
                    }

                    @Override
                    public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                        super.onAdFailedToShowFullScreenContent(adError);
                        openNextActivity(mActivity, cls, what, handler);
                    }
                });
                mInterstitialAd.show(mActivity);
            } else {
                openNextActivity(mActivity, cls, what, handler);
            }
        } else {
            openNextActivity(mActivity, cls, what, handler);
        }
    }

    private static void openNextActivity(Activity mActivity, Class cls, final int what, final Handler handler) {
        if (handler != null) {
            final Message message = Message.obtain();
            handler.sendEmptyMessage(what);
            message.setTarget(handler);
            message.sendToTarget();
        } else {
            Screens.showCustomScreen(mActivity, cls);
        }
    }

    /*public static int getDrawableImage(Context mContext, int position) {
        String themeType = AlphaTheme.DEFAULT.toString();
        return getDrawableImage(mContext, themeType, position);
    }*/

    /*public static int getDrawableImage(Context mContext, String themeType, int position) {
        themeType = themeType.equalsIgnoreCase("") ? AlphaTheme.DEFAULT.toString() : themeType;
        return mContext.getResources().getIdentifier(themeType + STR_ALPHABETS[position], "drawable", mContext.getPackageName());
    }*/

    public static int getDrawableImage(Context mContext, String themeType, String str) {
        themeType = themeType.equalsIgnoreCase("") ? AlphaTheme.DEFAULT.toString() : themeType;
        return mContext.getResources().getIdentifier(themeType + str, "drawable", mContext.getPackageName());
    }


    public static int getRawAudio(Context mContext, String audioMaleFemale, int position) {
        audioMaleFemale = audioMaleFemale.equalsIgnoreCase("") ? AlphaTheme.MALE.toString() : audioMaleFemale;
        return mContext.getResources().getIdentifier(audioMaleFemale + StaticNames.STR_ALPHABETS[position], "raw", mContext.getPackageName());
    }

    public static int getRawAudioDefault(Context mContext, int position) {
        return mContext.getResources().getIdentifier(StaticNames.STR_ALPHABETS[position], "raw", mContext.getPackageName());
    }


    public static int getRawAudio(Context mContext, String audioMaleFemale, String str) {
        audioMaleFemale = audioMaleFemale.equalsIgnoreCase("") ? AlphaTheme.MALE.toString() : audioMaleFemale;
        return mContext.getResources().getIdentifier(audioMaleFemale + str, "raw", mContext.getPackageName());
    }

    public static int getRawAudioDefault(Context mContext, String str) {
        return mContext.getResources().getIdentifier(str, "raw", mContext.getPackageName());
    }

    private static String strSelectedTheme = "";
    private static String[] strArray = null;
    private static int index = -1;

    /*
     * selectTheme -> Default, Picture, Puzzle, etc
     * */
    public static void selectTheme(final Activity mContext, final String selectTheme, final IAlphaListener iAlphaListener) {

        strArray = mContext.getResources().getStringArray(R.array.arrAlphaTheme);
        if (Utils.isEmpty(selectTheme)) {
            index = -1;
        } else {
            index = Arrays.asList(strArray).indexOf(selectTheme);
            strSelectedTheme = selectTheme;
        }

        final AlertDialog.Builder builder = new AlertDialog.Builder(mContext);

        CardView view = (CardView) mContext.getLayoutInflater().inflate(R.layout.dialog_theme_alpha, null);
//        final SessionManager session = new SessionManager(mContext);

        /*if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            if (session.isRTLOn()) {
                view.setLayoutDirection(View.LAYOUT_DIRECTION_RTL);
            } else {
                view.setLayoutDirection(View.LAYOUT_DIRECTION_LTR);
            }
        }*/

        final RadioGroup radioGroup = view.findViewById(R.id.rdoGroupGender);
        final RadioButton radioDefault = view.findViewById(R.id.rdoDefault);
        final RadioButton radioThreeD = view.findViewById(R.id.rdoThreeD);
        final RadioButton radioPuzzle = view.findViewById(R.id.rdoPuzzle);
        final RadioButton radioShiny = view.findViewById(R.id.rdoShiny);
        final RadioButton radioPicture = view.findViewById(R.id.rdoPicture);
        final RadioButton radioWords = view.findViewById(R.id.rdoWords);
        final AppCompatButton btnCancel = view.findViewById(R.id.btnCancel);
        final AppCompatButton btnDone = view.findViewById(R.id.btnDone);

        builder.setView(view);
        String themeValue = selectTheme; //session.getAlphaValue();

        if (themeValue.equalsIgnoreCase(mContext.getString(R.string.strDefault))) {

            setRadioButtonTrueFalse(radioDefault, radioThreeD, radioPuzzle, radioShiny, radioPicture, radioWords);

        } else if (themeValue.equalsIgnoreCase(mContext.getString(R.string.strThreeD))) {

            setRadioButtonTrueFalse(radioThreeD, radioDefault, radioPuzzle, radioShiny, radioPicture, radioWords);

        } else if (themeValue.equalsIgnoreCase(mContext.getString(R.string.strPuzzle))) {

            setRadioButtonTrueFalse(radioPuzzle, radioDefault, radioThreeD, radioShiny, radioPicture, radioWords);

        } else if (themeValue.equalsIgnoreCase(mContext.getString(R.string.strShiny))) {

            setRadioButtonTrueFalse(radioShiny, radioDefault, radioThreeD, radioPuzzle, radioPicture, radioWords);

        } else if (themeValue.equalsIgnoreCase(mContext.getString(R.string.strPicture))) {

            setRadioButtonTrueFalse(radioPicture, radioDefault, radioThreeD, radioShiny, radioPuzzle, radioWords);

        } else if (themeValue.equalsIgnoreCase(mContext.getString(R.string.strWords))) {

            setRadioButtonTrueFalse(radioWords, radioDefault, radioThreeD, radioShiny, radioPuzzle, radioPicture);

        } else {

            setRadioButtonTrueFalse(radioDefault, radioThreeD, radioPuzzle, radioShiny, radioPicture, radioWords);

        }

        radioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @SuppressLint("ResourceType")
            @Override
            public void onCheckedChanged(RadioGroup group, int checkedId) {
                RadioButton rb = group.findViewById(checkedId);
                if (null != rb && checkedId > -1) {
                    strSelectedTheme = rb.getText().toString();
                }

            }
        });

        final AlertDialog alert = builder.create();

        btnCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                alert.dismiss();
            }
        });

        btnDone.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (Utils.isEmpty(strSelectedTheme)) {
                    Toast.makeText(mContext, mContext.getString(R.string.msgSelectTheme), Toast.LENGTH_LONG).show();
                } else {
                    iAlphaListener.clickListener(strSelectedTheme);
                    alert.dismiss();
                }

                alert.dismiss();
            }
        });

        alert.getWindow().setBackgroundDrawableResource(android.R.color.transparent);
        alert.setCanceledOnTouchOutside(false);
        alert.setCancelable(false);
        alert.show();
    }

    private static void setRadioButtonTrueFalse(RadioButton orgButton, RadioButton... radioButtons) {
        orgButton.setChecked(true);
        for (RadioButton radioButton : radioButtons) {
            radioButton.setChecked(false);
        }
    }

    public static Typeface getCustomFont(Activity mActivity) {
        return ResourcesCompat.getFont(mActivity, R.font.sansation_regular);
    }

    public static String getAppVersionName() {
        return BuildConfig.VERSION_NAME;
    }
}